/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.IModelElementDelta;
import com.aptana.editor.php.core.model.IParent;
import com.aptana.editor.php.core.model.env.MemberElementInfo;
import com.aptana.editor.php.core.model.env.ModelElementInfo;
import com.aptana.editor.php.core.model.env.SourceMethodElementInfo;
import com.aptana.editor.php.internal.model.ModelElementDelta;
import com.aptana.editor.php.internal.model.impl.AbstractModelElement;
import com.aptana.editor.php.internal.model.impl.SourceModel;
import com.aptana.editor.php.internal.model.impl.env.SourceTypeElementInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelElementDeltaBuilder {
    IModelElement modelElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    ModelElementDelta delta;
    List added;
    List removed;

    public ModelElementDeltaBuilder(IModelElement modelElement) {
        this.modelElement = modelElement;
        this.initialize();
        this.recordElementInfo(modelElement, (SourceModel)this.modelElement.getModel(), 0);
    }

    public ModelElementDeltaBuilder(IModelElement modelElement, int maxDepth) {
        this.modelElement = modelElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(modelElement, (SourceModel)this.modelElement.getModel(), 0);
    }

    private void added(IModelElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public ModelElementDelta buildDeltas() {
        this.delta = new ModelElementDelta(this.modelElement);
        if (this.modelElement.getElementType() >= 5) {
            this.delta.fineGrained();
        }
        this.recordNewPositions(this.modelElement, 0);
        this.findAdditions(this.modelElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.modelElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
        return this.delta;
    }

    private void findAdditions(IModelElement newElement, int depth) {
        IModelElement[] children;
        ModelElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        ModelElementInfo newInfo = null;
        newInfo = ((AbstractModelElement)newElement).getElementInfo();
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IModelElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            ModelElementInfo info = null;
            info = ((AbstractModelElement)element).getElementInfo();
            IModelElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(ModelElementInfo oldInfo, ModelElementInfo newInfo, IModelElement newElement) {
        if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
            if (((MemberElementInfo)oldInfo).getModifiers() != ((MemberElementInfo)newInfo).getModifiers()) {
                this.delta.changed(newElement, 2);
            } else if (oldInfo instanceof SourceMethodElementInfo && newInfo instanceof SourceMethodElementInfo) {
                SourceMethodElementInfo oldSourceMethodInfo = (SourceMethodElementInfo)oldInfo;
                SourceMethodElementInfo newSourceMethodInfo = (SourceMethodElementInfo)newInfo;
                if (!ModelElementDeltaBuilder.equals(oldSourceMethodInfo.getArgumentNames(), newSourceMethodInfo.getArgumentNames()) || !ModelElementDeltaBuilder.equals(oldSourceMethodInfo.getArgumentInitializers(), newSourceMethodInfo.getArgumentInitializers())) {
                    this.delta.changed(newElement, 1);
                }
            }
        }
        if (oldInfo instanceof SourceTypeElementInfo && newInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo oldSourceTypeInfo = (SourceTypeElementInfo)oldInfo;
            SourceTypeElementInfo newSourceTypeInfo = (SourceTypeElementInfo)newInfo;
            if (!ModelElementDeltaBuilder.equals(oldSourceTypeInfo.getSuperclassNames(), newSourceTypeInfo.getSuperclassNames())) {
                this.delta.changed(newElement, 2048);
            }
        }
    }

    private void findDeletions() {
        for (IModelElement element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private ModelElementInfo getElementInfo(IModelElement element) {
        return (ModelElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IModelElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IModelElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.modelElement, new ListItem(null, null));
        this.putNewPosition(this.modelElement, new ListItem(null, null));
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IModelElement[] elements, boolean isNew) {
        int length = elements.length;
        IModelElement previous = null;
        IModelElement current = null;
        IModelElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IModelElement iModelElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IModelElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IModelElement oldPrevious = oldListItem.previous;
        IModelElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IModelElement element, ModelElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IModelElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IModelElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IModelElement element, SourceModel model, int depth) {
        IModelElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        ModelElementInfo info = null;
        if (element instanceof AbstractModelElement) {
            info = ((AbstractModelElement)element).getElementInfo();
        }
        if (info == null) {
            return;
        }
        int sizeBeforeInsert = this.infos.size();
        this.putElementInfo(element, info);
        if (sizeBeforeInsert == this.infos.size()) {
            return;
        }
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IModelElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            ModelElementInfo info = null;
            info = ((AbstractModelElement)newElement).getElementInfo();
            IModelElement[] children = info.getChildren();
            if (children != null) {
                int sizeBeforeInsertion = this.newPositions.size();
                this.insertPositions(children, true);
                if (sizeBeforeInsertion == this.newPositions.size()) {
                    return;
                }
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IModelElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IModelElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(ModelElementDelta elementDelta) {
        if (elementDelta.getKind() == 2) {
            IModelElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                elementDelta.removeAffectedChild((ModelElementDelta)children[i]);
                ++i;
            }
        } else {
            IModelElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((ModelElementDelta)children[i]);
                ++i;
            }
        }
    }

    private static final boolean equals(String[] first, String[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length - 1;
        while (i >= 0) {
            if (first[i] == null && second[i] != null) {
                return false;
            }
            if (first[i] != null && second[i] == null) {
                return false;
            }
            if (first[i] != null && !first[i].equals(second[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    static class ListItem {
        public IModelElement previous;
        public IModelElement next;

        protected ListItem(IModelElement previous, IModelElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

